#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12495);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0396");
 name["english"] = "RHSA-2004-190: cvs";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the cvs package installed.

cvs is a version control system. There is a flaw in the remote version
of CVS where a malformed 'Entry' line could cause a heap overflow, which
could allow an attacker to execute arbitrary code under the UID which
the CVS server is executing.

Solution : https://rhn.redhat.com/errata/RHSA-2004-190.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cvs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");
if ( rpm_check(release:"RHEL2.1", reference:"cvs-1.11.1p1-14") ||
     rpm_check(release:"RHEL3", reference:"cvs-1.11.2-22" ) ) security_hole(0);
