#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12496);
 script_bugtraq_id(10385);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0398");
 name["english"] = "RHSA-2004-191: cadaver";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the cadaver package installed.

cadaver is a command-line WebDAV client which uses inbuilt code from neon,
an HTTP and WebDAV client library.

There is a heap overflow condition in the remote version of this software
which may allow an attacker to execute arbitary code on this host. To exploit
this flaw, an attacker would need to set up a rogue WebDAV server and lure
a victim on the remote host to connect to it using cadaver.

Solution : https://rhn.redhat.com/errata/RHSA-2004-191.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cadaver package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(reference:"cadaver-0.22.1-1.0", release:"RHEL2.1") )
	security_hole(0);
