#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12497);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0426");
 name["english"] = "RHSA-2004-192: rsync";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the rsync package installed.

rsync, a program for synchronizing files over the network, do not properly
sanitize paths when running a read/write deamon using using chroot. This
could allow an attacker to write files outside of the module path.

Only users running a read-write rsync daemon are affected by this problem.

Solution : https://rhn.redhat.com/errata/RHSA-2004-192.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the rsync package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");
if ( rpm_check(release:"RHEL2.1",  reference:"rsync-2.5.7-3.21AS", yank:"AS") ||
     rpm_check(release:"RHEL3", reference:"rsync-2.5.7-4.3E", yank:"E" ) ) security_hole(0);
