#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12498);
 script_bugtraq_id(10003, 10004);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0183", "CAN-2004-0184");
 name["english"] = "RHSA-2004-219: tcpdump";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the tcpdump, libpcap and/or arpwatch 
packages installed.

These packages, which have to do with network sniffing, contain a bug
in the way they parse ISAKMP packets. A remote attacker could exploit this 
issue by sending a specially malformed network packet to the remote host, 
while a user is running one of these packages. As a result, the attacker 
would be able to execute arbitrary code on the remote host, as the 'pcap' user.

Solution : https://rhn.redhat.com/errata/RHSA-2004-219.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tcpdump package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( release:"RHEL2.1",  reference:"tcpdump-3.6.2-12.2.1AS.6", prefix:"tcpdump-", yank:"AS" ) ||
     rpm_check( release:"RHEL2.1",  reference:"libpcap-0.6.2-12.2.1AS.6", prefix:"libpcap-", yank:"AS") ||
     rpm_check( release:"RHEL2.1",  reference:"arpwatch-2.1a11-12.2.1AS.6", prefix:"arpwatch-", yank:"AS") ||
     rpm_check( release:"RHEL3",    reference:"tcpdump-3.7.2-7.E3.2", yank:"E", prefix:"tcpdump-") ||
     rpm_check( release:"RHEL3",    reference:"libpcap-0.7.2-7.E3.2", yank:"E", prefix:"libpcap-") )
	security_hole(0);
