#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12499);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0411");
 name["english"] = "RHSA-2004-222: kdelibs";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the kdelibs package installed.

This package contains a URI handling issue which may allow a rogue website
to overwrite arbitrary files on the local filesystem or to gain access to the
kmail application with the privileges and emails of the user visiting the
website.

Solution : https://rhn.redhat.com/errata/RHSA-2004-222.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kdelibs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"kdelibs-", reference:"kdelibs-3.1.3-6.4", release:"RHEL3") ||
     rpm_check(prefix:"(kdelibs|arts)-", reference:"kdelibs-2.2.2-11", release:"RHEL2.1"))
	security_hole(0);

