#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12500);
 script_bugtraq_id(10499);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0414", "CAN-2004-0416", "CAN-2004-0417", "CAN-2004-0418");
 name["english"] = "RHSA-2004-233: cvs";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the cvs package installed.

cvs is a version control system. There are various flaws in the remote
CVS package which may allow an attacker to execute arbitrary code on this host.

Solution : https://rhn.redhat.com/errata/RHSA-2004-233.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cvs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL2.1", reference:"cvs-1.11.1p1-16") || 
     rpm_check(release:"RHEL3",   reference:"cvs-1.11.2-24") ) security_hole(0);
