#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12501);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0504", "CAN-2004-0505", "CAN-2004-0506");
 name["english"] = "RHSA-2004-234: ethereal";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the ethereal package installed.

Ethereal, a network sniffer, is vulnerable to various security issues
in the MMSE, SIP, SPNEGO dissectors, which may allow an attacker to execute 
arbitrary code on the remote host. To exploit these vulnerabilities, the 
attacker would need to send malformed traffic on the wire while a user of the 
remote host is sniffing traffic using ethereal.

Solution : https://rhn.redhat.com/errata/RHSA-2004-234.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ethereal package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"ethereal-", release:"RHEL2.1", reference:"ethereal-0.10.3-0.AS21.3", yank:"AS") ||
     rpm_check(prefix:"ethereal-", release:"RHEL3",   reference:"ethereal-0.10.3-0.30E.2", yank:"E") ) security_hole(0);
