#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12502);
 script_bugtraq_id(10448);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0523");
 name["english"] = "RHSA-2004-236: krb5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the krb5 package installed.

krb5 (kerberos) is a network authentication system. There are various
bugs in the remote krb5 package which may allow a remote attacker to 
execute arbitrary code on this server with root privileges.

To exploit this flaw, kerberos needs to be enabled as a server on this host.

Solution : https://rhn.redhat.com/errata/RHSA-2004-236.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the krb5 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL2.1", prefix:"krb5-", reference:"krb5-server-1.2.2-27" ) ||
     rpm_check(release:"RHEL3",   prefix:"krb5-", reference:"krb5-server-1.2.7-24") ) security_hole(0);
