#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12504);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0541");
 name["english"] = "RHSA-2004-242: Squid";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Squid package installed.

Squid is a Web proxy cache. There is a bug in the remote version of this
package in the way it handles NTLM authentication, which may allow an
attacker to execute arbitrary code on the remote host by sending a
specially crafted NTLM authentication request.

Solution : https://rhn.redhat.com/errata/RHSA-2004-242.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Squid package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(reference:"squid-2.5.STABLE3-6.3E", yank:"STABLE", epoch:7, release:"RHEL3") )
	security_hole(0);
