#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12505);
 script_bugtraq_id(10454);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0536");
 name["english"] = "RHSA-2004-244: Tripwire";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the tripwire package installed

tripwire is a system integrity assessment tool. There is a format string
vulnerability in the remote version of this package which may allow a local
user to gain super-user privileges.

To exploit this flaw, tripwire would need to be configured to send reports 
via email, and a local attacker would need to create a file with a specially
crafted name containing a format string.

Solution : https://rhn.redhat.com/errata/RHSA-2004-244.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tripwire package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(reference:"tripwire-2.3.1-18", release:"RHEL2.1") )
	security_hole(0);

