#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12506);
 script_bugtraq_id(10508);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2004-0488", "CAN-2004-0492");
 name["english"] = "RHSA-2004-244: httpd and mod_ssl";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the httpd and mod_ssl packages installed

Two security issues exist in the remote version of these packages :


- A buffer overflow has been found in the Apache proxy module (mod_proxy) when
it receives a negative Content-Length header. This bug is not believed to
be exploitable.

- A stack buffer overflow has been discovered in mod_ssl, which can only
be triggered if the FakeBasicAuth option is used.

Solution : https://rhn.redhat.com/errata/RHSA-2004-245.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the httpd and mod_ssl packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"apache-", reference:"apache-1.3.27-8.ent", release:"RHEL2.1", yank:".ent") ||
     rpm_check(reference:"mod_ssl-2.8.12-4", release:"RHEL2.1") )
	security_warning(0);
else if ( rpm_exists(rpm:"mod_ssl-", release:"RHEL2.1") )
	set_kb_item(name:"CAN-2004-0488", value:TRUE);

