#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12507);
 script_bugtraq_id(6431);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2002-1363");
 name["english"] = "RHSA-2004-249: libpng";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the libpng package installed
(older than 1.2.2-24 and 1.0.13-14)

libpng is a package which contains a library of functions which 
support program designed to manipulate the PNG file format.

There is a buffer overflow condition in the remote version of this software
which may allow an attacker to execute arbitrary code on this host. To exploit
this flaw, an attacker would need to send a malformed PNG image file to a 
victim on the remote host and wait for him to open the file with an application
using libpng (most Linux graphical applications use this library when
dealing with this file format).


Solution : https://rhn.redhat.com/errata/RHSA-2004-249.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libpng package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(release:"RHEL3", prefix:"libpng-",   reference:"libpng-1.2.2-24") ||
     rpm_check(release:"RHEL3", prefix:"libpng10-", reference:"libpng10-1.0.13-14") ) 
		security_hole(0);
