#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12508);
 script_bugtraq_id(10221);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0427", "CAN-2004-0495", "CAN-2004-0554");
 name["english"] = "RHSA-2004-255: Linux Kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Linux Kernel package installed
(older than kernel-2.4.21-15.0.2.EL).

The remote Linux Kernel, which handles the basic functions of the operating 
system contains several security issues :

- A local user may trigger a denial of service by causing a system crash
by launching a specially crafted application.

- A local user may cause a denial of service by causing a memory leak by
passing invalid arguments to the clone() function.

- An unprivileged local user may be able to read the content of the kernel
memory by exploiting a bug in some of the drivers.


Solution : https://rhn.redhat.com/errata/RHSA-2004-255.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"kernel-", reference:"kernel-2.4.21-15.0.2.EL", yank:"EL", release:"RHEL3") )
	security_hole(0);

