#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13658);
 script_bugtraq_id(10780, 10781);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2004-0600", "CAN-2004-0686");
 name["english"] = "RHSA-2004-259: Samba";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Samba package installed.

Samba provides file and printer sharing services to SMB/CIFS clients. Samba
comes with a utility called 'SWAT' which is a web-based administration
tool for Samba installations.

There are various buffer overflows in SWAT which may allow an attacker
to execute arbitrary commands on the remote host. 

There are also flaws in the samba server if the option 'mangling method'
is set to 'hash' in smb.conf.

Solution : http://rhn.redhat.com/errata/RHSA-2004-259.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Samba package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"samba-", reference:"samba-3.0.4-6.3E", yank:"E", release:"RHEL3") ) security_hole(0);
else if ( rpm_exists(rpm:"samba-3", release:"RHEL3") ) 
{
	set_kb_item(name:"CAN-2004-0686", value:TRUE);
}
