#
# (C) Tenable Network Security
#
#
if ( ! defined_func("bn_random") ) exit(0);


if(description)
{
 script_id(14310);
 script_bugtraq_id(7929);
 script_version ("$Revision: 1.5 $");
 script_cve_id("CAN-2003-0388");

			
 name["english"] = "RHSA-2004-304: pam";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a vulnerable version of PAM.

Pluggable Authentication Modules (PAM) are a security tool which allows
Linux users to authenticate against a myriad of disparate authentication
server.  

This version of PAM has a problem wherein valid users will be able
to escalate their privileges to the superuser.  In additition, there
are at least two flaws within the logging mechanism which would 
erroneously log incorrect User IDs to the lastlog system logfile.
An attacker, exploiting these flaws, would need to either have local
access to the machine or a valid UserID/Password (for account privilege
escalation).
 
Solution : http://rhn.redhat.com/errata/RHSA-2004-304.html

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pam package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"pam-0.75-46.9", prefix:"pam-", release:"RHEL2.1") ) 
	security_hole(0);


