#
# (C) Tenable Network Security
#
#
# Text of the advisory is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14625);
 script_bugtraq_id(11093);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0694", "CAN-2004-0745", "CAN-2004-0769", "CAN-2004-0771");

 name["english"] = "RHSA-2004-323: lha";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the lha package installed.

LHA is an archiving and compression utility for LHarc format archives.

Lukasz Wojtow discovered a stack-based buffer overflow in all versions
of lha up to and including version 1.14. A carefully created archive could
allow an attacker to execute arbitrary code when a victim extracts or tests
the archive. The Common Vulnerabilities and Exposures project
(cve.mitre.org) has assigned the name CAN-2004-0769 to this issue.

Buffer overflows were discovered in the command line processing of all
versions of lha up to and including version 1.14. If a malicious user
could trick a victim into passing a specially crafted command line to the
lha command, it is possible that arbitrary code could be executed. The
Common Vulnerabilities and Exposures project (cve.mitre.org) has assigned
the names CAN-2004-0771 and CAN-2004-0694 to these issues.

Thomas Biege discovered a shell meta character command execution
vulnerability in all versions of lha up to and including 1.14. An attacker
could create a directory with shell meta characters in its name which could
lead to arbitrary command execution. The Common Vulnerabilities and
Exposures project (cve.mitre.org) has assigned the name CAN-2004-0745 to
this issue.

Users of lha should update to this updated package which contains
backported patches and is not vulnerable to these issues.


Solution : http://rhn.redhat.com/errata/RHSA-2004-323.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the lha package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");
if ( rpm_check(release:"RHEL3", reference:"lha-1.14i-10.4", yank:"i" ) )
	 security_hole(0);
