#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#
# (C) Tenable Network Security
#
#
# This script is released under the GNU GPLv2

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12636);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2004-0488", "CAN-2004-0493");
 name["english"] = "RHSA-2004-342: httpd and mod_ssl";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the httpd and mod_ssl packages installed

Two security issues exist in the remote version of these packages :


- A buffer overflow has been found in the Apache proxy module (mod_proxy) when
it receives a negative Content-Length header. This bug is not believed to
be exploitable.

- A stack buffer overflow has been discovered in mod_ssl, which can only
be triggered if the FakeBasicAuth option is used.

Solution : https://rhn.redhat.com/errata/RHSA-2004-342.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the httpd and mod_ssl packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check(prefix:"(httpd|mod_ssl)-", 
               release:"RHEL3", 
	       reference:"httpd-2.0.46-32.ent", 
               yank:"ent") ) security_warning(0);

