#
# (C) Tenable Network Security
#
#
if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14595);
 script_bugtraq_id(11078, 11079);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0642", "CAN-2004-0643", "CAN-2004-0644", "CAN-2004-0772");

			
 name["english"] = "RHSA-2004-350: krb5";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of the krb5 (kerberos) RPM which is older 
than 1.2.7-28.

There are two flaws in the remote version of this package :

- The ASN.1 decoder library is vulnerable to a denial of service
attack which may allow an attacker to crash the KDC remotely

- There is a double free vulnerability in the KDC which might allow an attacker
to execute arbitrary code remotely.

Solution : http://rhn.redhat.com/errata/RHSA-2004-350.html
Risk Factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the krb5 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"krb5-1.2.7-28", prefix:"krb5-", release:"RHEL3") )
	security_hole(0);


