#
# (C) Tenable Network Security
#
#
if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14211);
 script_bugtraq_id(10864);
 script_version ("$Revision: 1.6 $");
 script_cve_id("CAN-2004-0494");
			
 name["english"] = "RHSA-2004-373: GNOME VFS";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
There is a flaw in several of the Gnome VFS extfs backend scripts.
An attacker, exploiting this bug, would need to be able to coerce
a local user to open a specially crafted URI.  If successful, the
attacker would gain remote access to the system.
 
GNOME VFS is the GNOME virtual file system. It provides a modular
architecture and ships with several modules that implement support for file
systems, HTTP, FTP, and others. The extfs backends make it possible to
implement file systems for GNOME VFS using scripts.

Solution : http://rhn.redhat.com/errata/RHSA-2004-373.html

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the GNOME VFS package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"gnome-vfs2-2.2.5-2E.1", yank:"E", prefix:"gnome-vfs2-", release:"RHEL3") ) 
	security_hole(0);

if ( rpm_check( reference:"gnome-vfs-1.0.1-18.1", prefix:"gnome-vfs-", release:"RHEL2.1") )
        security_hole(0);



