#
# (C) Tenable Network Security
#
#
if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14215);
 script_version ("$Revision: 1.5 $");
script_cve_id("CAN-2004-0633","CAN-2004-0634","CAN-2004-0635");
			
 name["english"] = "RHSA-2004-378: Ethereal";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of ethereal prior to 0.10.5.

This version of ethereal is vulnerable to multiple flaws within
it's protocol analysis modules.  An attacker can use these flaws
to execute code on the remote machine.  An attacker, exploiting
these flaws would need to know (or guess) that a remote user is
using ethereal to sniff network traffic.  Further, the attacker
would need to know that the user was sniffing one of the vulnerable
network protocols and displaying the protocols via the ethereal
protocol dissector.  The relevant protocols are:
iSNS
SMB
SNMP

Solution : http://rhn.redhat.com/errata/RHSA-2004-378.html

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Ethereal package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"ethereal-0.10.5-0.AS21.2", yank:"AS", prefix:"ethereal-", release:"RHEL2.1") ||
	rpm_check( reference:"ethereal-0.10.5-0.30E.2", yank:"E", prefix:"ethereal-", release:"RHEL3") )
	security_hole(0);


