#
# (C) Tenable Network Security
#
#
if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14212);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2002-0029");
			
 name["english"] = "RHSA-2004-383: glibc";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of glibc prior to 2.3.2.

Glibc is used in the DNS resolver library.  There is a flaw
in the way that GLIBC handles certain malformed DNS replies.
An attacker, exploiting this flaw, would need to own a DNS server
and have the ability to coerce the vulnerable Linux machine to
use their DNS server to resolve a name or IP.  A successful attack
would give the remote attacker the ability to execute arbitrary code.

Solution : http://rhn.redhat.com/errata/RHSA-2004-383.html

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the glibc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"glibc-2.2.4-32.17", prefix:"glibc-", release:"RHEL2.1") ) 
	security_hole(0);

if ( rpm_check( reference:"nscd-2.2.4-32.17", prefix:"nscd-", release:"RHEL2.1") )
        security_hole(0);


