#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#
# (C) Tenable Network Security
#
# ref: Stefan Esser
# This script is released under the GNU GPLv2

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13652);
 script_bugtraq_id(10724, 10725);
 script_version ("$Revision: 1.5 $");
 script_cve_id("CAN-2004-0594", "CAN-2004-0595");
 if ( defined_func("script_xref") ) script_xref(name:"OSVDB", value:"7870");
 if ( defined_func("script_xref") ) script_xref(name:"OSVDB", value:"7871");
 
 name["english"] = "RHSA-2004-395: php";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the php package installed.
There is a flaw when memory_limit configuration setting is
enabled in versions of PHP 4 before 4.3.8. If a remote attacker could
force the PHP interpreter to allocate more memory than the memory_limit
setting before script execution begins, then the attacker may be
able to supply the contents of a PHP hash table remotely. This hash table
could then be used to execute arbitrary code as the 'apache' user.

There is a flaw in the strip_tags function in versions of
PHP before 4.3.8. The strip_tags function is commonly used by PHP scripts
to prevent Cross-Site-Scripting attacks by removing HTML tags from
user-supplied form data. By embedding NUL bytes into form data, HTML tags
can in some cases be passed intact through the strip_tags function, which
may allow a Cross-Site-Scripting attack. 

Solution : https://rhn.redhat.com/errata/RHSA-2004-395.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the php package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"php-4.1.2-2.1.8", prefix:"php-", release:"RHEL2.1") ) 
	security_warning(0);
else if ( rpm_exists(rpm:"php-4", release:"RHEL2.1") )
	{
	set_kb_item(name:"CAN-2004-0594", value:TRUE);
	set_kb_item(name:"CAN-2004-0595", value:TRUE);
	}
