#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14696);
 script_cve_id("CAN-2004-0500", "CAN-2004-0754", "CAN-2004-0784", "CAN-2004-0785");
 script_version ("$Revision: 1.1 $");
 name["english"] = "RHSA-2004-400: gaim";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the gaim package installed
(older than gaim-0.82.1-0.RHEL3)

Gaim, an instant messenger client, contains a number of bugs which may
allow an attacker to execute arbitrary code on the remote host.

To exploit these bugs, an attacker would need to send malformed instant
messages to a user of this host.

Solution : https://rhn.redhat.com/errata/RHSA-2004-400.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gaim package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"gaim-0.82.1-0.RHEL3",yank:"RHEL3", release:"RHEL3") )
	security_hole(0);

