#
# (C) Tenable Network Security
#
#
if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14213);
 script_bugtraq_id(10857);
 script_version ("$Revision: 1.6 $");
 script_cve_id("CAN-2002-1363","CAN-2004-0597","CAN-2004-0598","CAN-2004-0599");
			
 name["english"] = "RHSA-2004-402: libpng";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of libpng which is 
vulnerable to a local attack.

Libpng is a library used for manipulating graphics files. 

Several buffer overflows have been discovered in libpng. An attacker
could create a carefully crafted PNG file in such a way that it would
cause an application linked with libpng to execute arbitrary code when
the file was opened by a victim.


Solution : http://rhn.redhat.com/errata/RHSA-2004-402.html

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libpng package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if  ( rpm_check( reference:"libpng-1.2.2-25", prefix:"libpng-", release:"RHEL3") )
	security_hole(0);

if  ( rpm_check( reference:"libpng10-1.0.13-15", prefix:"libpng10-", release:"RHEL3") )
        security_hole(0);

if  ( rpm_check( reference:"libpng-1.0.14-7", prefix:"libpng-", release:"RHEL2.1") )
        security_hole(0);




