#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13853);
 script_bugtraq_id(10819);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0557");
 name["english"] = "RHSA-2004-409: Sox";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Sox package installed.

SoX (Sound eXchange) is a sound file format converter SoX can convert
between many different digitized sound formats and perform simple
sound manipulation functions, including sound effects.

Update Information:

Updated sox packages that fix buffer overflows in the WAV file handling
code are now available.

Buffer overflows existed in the parsing of WAV file header fields. It
was possible that a malicious WAV file could have caused arbitrary
code to be executed when the file was played or converted.


Solution : http://rhn.redhat.com/errata/RHSA-2004-409.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the sox package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"sox-", reference:"sox-12.17.4-4.3", release:"RHEL3") ) 
	security_hole(0);
