#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
# This script is released under the GNU GPLv2

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14239);
 script_bugtraq_id(10783, 10852);
 script_version ("$Revision: 1.5 $");
 script_cve_id("CAN-2004-0178", "CAN-2004-0415", "CAN-2004-0447", "CAN-2004-0535");
 name["english"] = "RHSA-2004-413: Linux Kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Linux Kernel package installed.

The remote Linux Kernel, which handles the basic functions of the operating 
system, contains various bugs which may allow a local user to gain super-user
privileges.

Solution : https://rhn.redhat.com/errata/RHSA-2004-413.html

Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"kernel-", reference:"kernel-2.4.21-15.0.4.EL", yank:"EL", release:"RHEL3") ) 
	security_hole(0);

