#
# (C) Tenable Network Security
#
#
if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14326);
 script_bugtraq_id(10977);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2004-0691", "CAN-2004-0692", "CAN-2004-0693");
			
 name["english"] = "RHSA-2004-414: qt";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running an older version of the qt package.

Qt is a software toolkit that simplifies the task of writing and maintaining
GUI applications for the X Window System.

There is a heap overflow in the remote version of this package (in the
BMP, GIF, XPM and JPEG decoders) which may allow an attacker to
execute arbitrary code on the remote host.

To exploit this flaw, an attacker would need to craft a malformed image
file and to send it to a victim on the remote host, and have the victim
open the file with a Qt-enabled application.

Solution : http://rhn.redhat.com/errata/RHSA-2004-414.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the qt package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"qt-3.1.2-13.4", prefix:"qt-", release:"RHEL3") ||
     rpm_check( reference:"qt-2.3.1-10", prefix:"qt-", release:"RHEL2.1") )
	security_hole(0);


