#
# (C) Tenable Network Security
#
#
if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14214);
 script_bugtraq_id(10874, 10875, 10876, 10877);
 script_version ("$Revision: 1.7 $");
script_cve_id("CAN-2004-0597","CAN-2004-0599","CAN-2004-0718","CAN-2004-0722","CAN-2004-0757");
# also "CAN-2004-0758" "CAN-2004-0759" "CAN-2004-0760" "CAN-2004-0761" "CAN-2004-0762"  "CAN-2004-0763" "CAN-2004-0764"
# "CAN-2004-0765" 
			
 name["english"] = "RHSA-2004-421: mozilla";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of the mozilla browser which 
is vulnerable to multiple remote overflows.

Mozilla is a web browser.  This version of mozilla is vulnerable
to more than a dozen remote exploits.  An attacker, exploiting
these flaws, would need to be able to coerce a local user into
browsing to a malicious website.  The malicious website would then
be able to run code within the security context of the browsing
user.  

Solution : http://rhn.redhat.com/errata/RHSA-2004-421.html

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mozilla package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"mozilla-1.4.3-3.0.2", prefix:"mozilla-", release:"RHEL3") ) 
	security_hole(0);

if ( rpm_check( reference:"galeon-1.2.13-3.2.1", prefix:"galeon-", release:"RHEL2.1") )
        security_hole(0);

if ( rpm_check( reference:"mozilla-1.4.3-2.1.2", prefix:"mozilla-", release:"RHEL2.1") )
        security_hole(0);



