#
# (C) Tenable Network Security
#
#
if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14380);
 script_bugtraq_id(10931, 10932);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0630", "CAN-2004-0631");
			
 name["english"] = "RHSA-2004-432: Acrobat";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running an older version of the Acrobat package.

Acrobat Read is a reader for PDF documents for X11.

There are several flaws in the remote version of this package, including
a buffer overflow when uuencoding documents and an input validation error
which may allow an attacker to execute arbitrary commands on the remote
host.

To exploit this flaw, an attacker would need to send a specially crafted
document to a victim on the remote host and wait for him to read the file
using Acrobat.

Solution : http://rhn.redhat.com/errata/RHSA-2004-432.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the acrobat package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"acroread-5.09-1", prefix:"acroread-", release:"RHEL3") )
	security_hole(0);


