#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14623);
 script_bugtraq_id(10938);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0792");
 name["english"] = "RHSA-2004-436: rsync";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the rsync package installed.

There is a flaw in this version of rsync which, due to an input validation
error, would allow a remote attacker to gain access to the remote system.

An attacker, exploiting this flaw, would need network access to the TCP port.  
Successful exploitation requires that the rsync daemon is *not* running chroot.


Solution : http://rhn.redhat.com/errata/RHSA-2004-436.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the rsync package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");
if ( rpm_check(release:"RHEL2.1",  reference:"rsync-2.5.7-3.21AS.1", yank:"AS") ||
     rpm_check(release:"RHEL3", reference:"rsync-2.5.7-5.3E", yank:"E" ) ) security_hole(0);
