#
# (C) Tenable Network Security
#
#
if ( ! defined_func("bn_random") ) exit(0);


if(description)
{
 script_id(14309);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0178");
			
 name["english"] = "RHSA-2004-437: kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote kernel, according to the version number, is vulnerable to a 
local attack in it's handling of Soundblaster 16 samples.  An attacker,
exploiting this flaw, would need local access to the machine as well
as the ability to craft and run sound files through the Soundblaster 16
driver.  A successful attack would potentially render the local machine
as unuseable.  This is a Denial of Service (DoS) type attack.

In addition, the following drivers have been updated:
cciss v2.4.52
e1000 v5252k1
e100 v2.3.43-k1
fusion v2.05.16
ips v7.00.15
aacraid v1.1.5
megaraid2 v2.10.6

Solution : http://rhn.redhat.com/errata/RHSA-2004-437.html

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"kernel-2.4.9-e.49", yank:"e", prefix:"kernel-", release:"RHEL2.1") ) 
	security_hole(0);

