#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15412);
 script_cve_id("CAN-2004-0755");
 script_version ("$Revision: 1.1 $");
 name["english"] = "RHSA-2004-441: Ruby";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
An updated ruby package that fixes insecure file permissions for CGI session
files is now available.

Ruby is an interpreted scripting language for object-oriented programming.

Andres Salomon reported an insecure file permissions flaw in the CGI
session management of Ruby. FileStore created world readable files that
could allow a malicious local user the ability to read CGI session data. 
The Common Vulnerabilities and Exposures project (cve.mitre.org) has
assigned the name CAN-2004-0755 to this issue.

Users are advised to upgrade to this erratum package, which contains a
backported patch to CGI::Session FileStore.


Solution : https://rhn.redhat.com/errata/RHSA-2004-441.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ruby package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"ruby-1.6.8-9.EL3.2", prefix:"ruby-", yank:"EL3.2", release:"RHEL3") ||     rpm_check( reference:"ruby-1.6.4-2.AS21.0", prefix:"ruby-", yank:"AS21.0", release:"RHEL2.1"))
	security_hole(0);
