#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14739);
 script_bugtraq_id(11151);
 script_cve_id("CAN-2004-0752");
 script_version ("$Revision: 1.2 $");
 name["english"] = "RHSA-2004-446: OpenOffice.org";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the OpenOffice.org package installed.

Updated openoffice.org packages that fix a security issue in temporary file
handling are now available.


OpenOffice.org is an office productivity suite that includes desktop
applications such as a word processor, spreadsheet, presentation manager,
formula editor, and drawing program.

Secunia Research reported an issue with the handling of temporary files. A
malicious local user could use this flaw to access the contents of another
user's open documents. The Common Vulnerabilities and Exposures project
(cve.mitre.org) has assigned the name CAN-2004-0752 to this issue.

All users of OpenOffice.org are advised to upgrade to these updated
packages which contain a backported patch to correct this issue.


Solution : https://rhn.redhat.com/errata/RHSA-2004-446.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the OpenOffice.org package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"openoffice.org-1.1.0-16.14.EL", yank:".EL", release:"RHEL3") ) 
	security_warning(0);
