#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14737);
 script_cve_id("CAN-2004-0558");
 script_version ("$Revision: 1.1 $");
 name["english"] = "RHSA-2004-449: CUPS";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the CUPS package installed
(older than cups-1.1.17-13.3)

Updated cups packages that fix a denial of service vulnerability are now
available.

The Common UNIX Printing System (CUPS) is a print spooler.

Alvaro Martinez Echevarria reported a bug in the CUPS Internet Printing
Protocol (IPP) implementation in versions of CUPS prior to 1.1.21. An
attacker could send a carefully crafted UDP packet to the IPP port which
could cause CUPS to stop listening to the port and result in a denial of
service. In order to exploit this bug, an attacker would need to have the
ability to send a UDP packet to the IPP port (by default 631). The
Common Vulnerabilities and Exposures project (cve.mitre.org) has assigned
the name CAN-2004-0558 to this issue.

All users of cups should upgrade to these updated packages, which contain a
backported patch as well as a fix for a non-exploitable off-by-one bug.


Solution : https://rhn.redhat.com/errata/RHSA-2004-449.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cups package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"cups-1.1.17-13.3", prefix:"cups-", release:"RHEL3") )
	security_warning(0);
