#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15410);
 script_cve_id("CAN-2004-0832");
 script_version ("$Revision: 1.1 $");
 name["english"] = "RHSA-2004-462: Squid";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running an  version of the squid package.

Squid is a full-featured Web proxy cache.

An out of bounds memory read bug was found within the NTLM authentication
helper routine. If Squid is configured to use the NTLM authentication
helper, a remote attacker could send a carefully crafted NTLM
authentication packet and cause Squid to crash. The Common Vulnerabilities
and Exposures project (cve.mitre.org) has assigned the name CAN-2004-0832
to this issue.

Note: The NTLM authentication helper is not enabled by default in Red Hat
Enterprise Linux 3. Red Hat Enterprise Linux 2.1 is not vulnerable to this
issue as it shipped with a version of Squid which did not contain the
vulnerable helper. 

Users of Squid should update to this erratum package, which contains a
backported patch and is not vulnerable to this issue.


Solution : https://rhn.redhat.com/errata/RHSA-2004-462.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the squid package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"squid-2.5.STABLE3-6.3E", yank:"STABLE", release:"RHEL3") )
	security_hole(0);
