#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14735);
 script_cve_id("CAN-2004-0817");
 script_version ("$Revision: 1.1 $");
 name["english"] = "RHSA-2004-465: imlib";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the imlib package installed
(older than imlib-1.9.13-4.2)

An updated imlib package that fixes several heap overflows is now available.

Imlib is an image loading and rendering library.

Several heap overflow flaws were found in the imlib BMP image handler. An
attacker could create a carefully crafted BMP file in such a way that it
could cause an application linked with imlib to execute arbitrary code when
the file was opened by a victim. The Common Vulnerabilities and Exposures
project (cve.mitre.org) has assigned the name CAN-2004-0817 to this issue.

Users of imlib should update to this updated package which contains
backported patches and is not vulnerable to this issue.


Solution : https://rhn.redhat.com/errata/RHSA-2004-465.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the imlib package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"imlib-1.9.13-13.3",prefix:"imlib-", release:"RHEL3")  || rpm_check( reference:"imlib-1.9.13-4.2", prefix:"imlib-", release:"RHEL2.1"))
	security_hole(0);
