#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14801);
 script_bugtraq_id(11156);
 script_cve_id("CAN-2004-0807", "CAN-2004-0808");
 script_version ("$Revision: 1.1 $");
 name["english"] = "RHSA-2004-467: Samba";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of samba which is older than
samba-3.0.7-1.3E.

Samba provides file and printer sharing services to SMB/CIFS clients.

The Samba team has discovered a denial of service bug in the smbd daemon. 
A defect in smbd's ASN.1 parsing allows an attacker to send a specially
crafted packet during the authentication request which will send the newly
spawned smbd process into an infinite loop. Given enough of these packets,
it is possible to exhaust the available memory on the server. The Common
Vulnerabilities and Exposures project (cve.mitre.org) has assigned the name
CAN-2004-0807 to this issue.

Additionally the Samba team has also discovered a denial of service bug in
the nmbd daemon. It is possible that an attacker could send a specially
crafted UDP packet which could allow the attacker to anonymously
crash nmbd. This issue only affects nmbd daemons which are configured to
process domain logons. The Common Vulnerabilities and Exposures project
(cve.mitre.org) has assigned the name CAN-2004-0808 to this issue.

Users of Samba should upgrade to these updated packages, which contain an
upgrade to Samba-3.0.7, which is not vulnerable to these issues.


Solution : https://rhn.redhat.com/errata/RHSA-2004-467.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the OpenOffice.org package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"samba-3.0.7-1.3", prefix:"samba-", yank:"E", release:"RHEL3") ) 
	security_warning(0);
