#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15426);
 script_cve_id("CAN-2004-0419", "CAN-2004-0687", "CAN-2004-0688", "CAN-2004-0692");
 script_version ("$Revision: 1.1 $");
 name["english"] = "RHSA-2004-478: XFree86";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Updated XFree86 packages that fix several security flaws in libXpm,
as well as other bugs, are now available for Red Hat Enterprise Linux 3.


XFree86 is an open source implementation of the X Window System. It
provides the basic low level functionality which full fledged graphical
user interfaces (GUIs) such as GNOME and KDE are designed upon.

During a source code audit, Chris Evans discovered several stack overflow
flaws and an integer overflow flaw in the X.Org libXpm library used to
decode XPM (X PixMap) images. An attacker could create a carefully crafted
XPM file which would cause an application to crash or potentially execute
arbitrary code if opened by a victim. The Common Vulnerabilities and
Exposures project (cve.mitre.org) has assigned the names CAN-2004-0687,
CAN-2004-0688, and CAN-2004-0692 to these issues.

A flaw was found in the X Display Manager (XDM). XDM is shipped with Red
Hat Enterprise Linux, but is not used by default. XDM opened a chooserFd
TCP socket even if the DisplayManager.requestPort parameter was set to 0.
This allowed authorized users to access a machine remotely via X, even if
the administrator had configured XDM to refuse such connections. Although
XFree86 4.3.0 was not vulnerable to this issue, Red Hat Enterprise Linux 3
contained a backported patch which introduced this flaw. The Common
Vulnerabilities and Exposures project (cve.mitre.org) has assigned the name
CAN-2004-0419 to this issue.

Users are advised to upgrade to these erratum packages, which contain
backported security patches to correct these and a number of other issues.

Solution : http://rhn.redhat.com/errata/RHSA-2004-478.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the XFree86 packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(reference:"XFree86-4.3.0-69.EL", prefix:"XFree86-", yank:".EL", release:"RHEL3") )
	security_hole(0);
