#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15441);
 script_bugtraq_id(11347);
 script_cve_id("CAN-2004-0844");
 script_version ("$Revision: 1.2 $");
 name["english"] = "RHSA-2004-546: cyrus-sasl";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Updated cyrus-sasl packages that fix a setuid and setgid application
vulnerability are now available.

The cyrus-sasl package contains the Cyrus implementation of SASL. SASL is
the Simple Authentication and Security Layer, a method for adding
authentication support to connection-based protocols.

At application startup, libsasl and libsasl2 attempts to build a list
of all available SASL plug-ins which are available on the system. To do
so, the libraries search for and attempt to load every shared library found
within the plug-in directory. This location can be set with the SASL_PATH
environment variable.

In situations where an untrusted local user can affect the environment of a
privileged process, this behavior could be exploited to run arbitrary code
with the privileges of a setuid or setgid application. The Common
Vulnerabilities and Exposures project (cve.mitre.org) has assigned the name
CAN-2004-0884 to this issue.

Users of cyrus-sasl should upgrade to these updated packages, which contain
backported patches and are not vulnerable to this issue.


Solution : http://rhn.redhat.com/errata/RHSA-2004-546.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cyrus-sasl packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(reference:"cyrus-sasl-2.1.15-10", prefix:"cyrus-sasl-", release:"RHEL3") ||
     rpm_check(reference:"cyrus-sasl-1.5.24-26", prefix:"cyrus-sasl-", release:"RHEL2.1") )
	security_hole(0);
