#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15534);
 script_cve_id("CAN-2004-0381", "CAN-2004-0388", "CAN-2004-0457");
 script_version ("$Revision: 1.1 $");
 name["english"] = "RHSA-2004-569: MySQL";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Updated mysql packages that fix various temporary file security issues,
as well as a number of bugs, are now available.

MySQL is a multi-user, multi-threaded SQL database server.

This update fixes a number of small bugs, including some potential
security problems associated with careless handling of temporary files.
The Common Vulnerabilities and Exposures project (cve.mitre.org) has
assigned the names CAN-2004-0381, CAN-2004-0388, and CAN-2004-0457 to these
issues.

A number of additional security issues that affect mysql have been
corrected in the source package. These include CAN-2004-0835,
CAN-2004-0836, CAN-2004-0837, and CAN-2004-0957. Red Hat Enterprise Linux
3 does not ship with the mysql-server package and is therefore not affected
by these issues.

This update also allows 32-bit and 64-bit libraries to be installed
concurrently on the same system.

All users of mysql should upgrade to these updated packages, which resolve
these issues.


Solution : http://rhn.redhat.com/errata/RHSA-2004-569.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the MySQL packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(reference:"mysql-3.23.58-2.3", prefix:"mysql-", release:"RHEL3") )
	{
	security_warning(0);
	exit(0);
	}

