#
# (C) Tenable Network Security
#
# $Id: smb_hotfixes.inc,v 1.5 2004/08/27 08:33:57 renaud Exp $

include("global_settings.inc");

function hotfix_check_exchange_installed()
{
 local_var vers;

 vers = get_kb_item("SMB/Registry/HKLM/SOFTWARE/Microsoft/Exchange/Setup/ServicePackBuild");
 if ( ! vers ) 
	return NULL;
 else 
	return vers;
}

function hotfix_data_access_version()
{
 local_var vers;

 vers = get_kb_item("SMB/Registry/HKLM/SOFTWARE/Microsoft/DataAccess/Version");
 if ( ! vers ) 
	return NULL;
 else 
	return vers;
}

#
# Returns 1 if IIS is installed, 0 if it is not and -1 if we don't know
#
function hotfix_check_iis_installed()
{
 local_var w3svc;

 w3svc = get_kb_item("SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Services/W3SVC/ImagePath");
 if ( ! w3svc ) return -1;
 if ( "inetinfo" >!< w3svc )
	return 0;
 else
	return 1;
}


function hotfix_check_nt_server()
{
 local_var product_options;
 product_options = get_kb_item("SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Control/ProductOptions");
 if ( ! product_options ) return -1;
 if ("WinNT" >< product_options ) 
	return 0;
 else
	return 1;
}

function hotfix_check_domain_controler()
{
 local_var product_options;
 product_options = get_kb_item("SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Control/ProductOptions");
 if ( ! product_options ) return -1;
 if ("LanmanNT" >< product_options ) 
	return 1;
 else
	return 0;
}

function hotfix_check_sp(nt, win2k, xp, win2003)
{
  local_var vers, sp;

  vers = get_kb_item("SMB/WindowsVersion");
  if ( ! vers ) return -1;

 

  if ( nt &&  "4.0" >< vers )
  {
    sp  = get_kb_item("SMB/WinNT4/ServicePack");
    if ( sp )
    	sp   = int(ereg_replace(string:sp, pattern:".*Service Pack ([0-9]).*", replace:"\1"));
    else
	sp = 0;

    if ( sp < nt )
 	return 1;
    else 
	return 0; 
  }   
  else if ( win2k &&  "5.0" >< vers )
  {
    sp  = get_kb_item("SMB/Win2K/ServicePack");
    if ( sp ) 
    	sp   = int(ereg_replace(string:sp, pattern:".*Service Pack ([0-9]).*", replace:"\1"));
    else
	sp = 0;
    if ( sp < win2k )
 	return 1;
    else 
	return 0; 
  }   
  else if ( xp &&  "5.1" >< vers )
  {
    sp  = get_kb_item("SMB/WinXP/ServicePack");
    if ( sp )
    	sp   = int(ereg_replace(string:sp, pattern:".*Service Pack ([0-9]).*", replace:"\1"));
    else
	sp = 0;
    if ( sp < xp )
 	return 1;
    else 
	return 0; 
  }   
  else if ( win2003 &&  "5.2" >< vers )
  {
    sp  = get_kb_item("SMB/Win2003/ServicePack");
    if ( sp ) 
    	sp   = int(ereg_replace(string:sp, pattern:".*Service Pack ([0-9]).*", replace:"\1"));
    else
	sp = 0;

    if ( sp < win2003 )
 	return 1;
    else 
	return 0; 
  }   

  return -1; 
}

#-----------------------------------------------------------------------------
# hotfix_missing()
#
# Returns:
# -1 : Could not verify if the hotfix is installed (ie: lack of credentials)
#  0 : The hotfix is installed
#  1 : The hotfix is missing
#-----------------------------------------------------------------------------
function hotfix_missing(name)
{
 local_var kb, key;

 
 kb = get_kb_list("SMB/Registry/*");
 if ( isnull(kb) || max_index(make_list(keys(kb))) == 0 )
 {
   return -1;
 }

 # Don't get confused by QNNNNN vs KBNNNNN updates - look for both formats
 if ( "KB" >< name ) name = name - "KB";
 else if ( "Q" >< name ) name = name - "Q";
 foreach key (keys(kb))
 {
  if ( ereg(pattern:"SMB/Registry/.*/(KB|Q)" + name, string:key) )
	return 0; # The hotfix is installed
 }
  return 1; # The hotfix is indeed missing
}
