#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13526);
 script_version ("$Revision: 1.5 $");
 script_bugtraq_id(8818, 8880, 9492);
 script_cve_id("CAN-2003-1000");
 name["english"] = "Solaris 9 (sparc) : 112960-19";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 112960-19
( patch libsldap ldap_cachemgr libldap).

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-112960-19-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 112960-19"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e =  solaris_check_patch(release:"5.9", arch:"sparc", patch:"112960-19", obsoleted_by:"113476-13", package:"SUNWarc SUNWarcx SUNWcsl SUNWcslx SUNWcstl SUNWcstlx SUNWhea SUNWnisu");

if ( e < 0 ) security_hole(0);
else if ( e > 0 )
{
	set_kb_item(name:"CAN-2003-1000", value:TRUE);
	set_kb_item(name:"BID-8818", value:TRUE);
	set_kb_item(name:"BID-8880", value:TRUE);
	set_kb_item(name:"BID-9492", value:TRUE);
}
