#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10267);
#script_cve_id("CVE-MAP-NOMATCH");
 script_version ("$Revision: 1.20 $");
 
 name["english"] = "SSH Server type and version";
 script_name(english:name["english"]);
 
 desc["english"] = "This detects the SSH Server's type and version by connecting to the server
and processing the buffer received.
This information gives potential attackers additional information about the
system they are attacking. Versions and Types should be omitted
where possible.

Solution: Apply filtering to disallow access to this port from untrusted hosts

Risk factor : Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "SSH Server type and version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 1999 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);
 script_require_ports("Services/ssh", 22);
 script_dependencies("find_service.nes", "find_service2.nasl", "external_svc_ident.nasl");
 exit(0);
}

#
# The script code starts here
#
include("misc_func.inc");

port = get_kb_item("Services/ssh");
if (!port) port = 22;
if (get_port_state(port))
{
 soc = open_sock_tcp(22);
 if ( ! soc ) exit(0);
 banner = recv_line(socket:soc, length:1024);
 close(soc);
 if(egrep(pattern:"SSH-.*-.*", string:banner)){
   if ( '\r\n' >< banner ) banner = banner - '\r\n';
   else banner = banner - '\n';

   set_kb_item(name:"SSH/banner/" + port, value:banner);
   banner = "Remote SSH version : " + banner + '\n';
   security_note(port:port, data:banner);
   register_service(port: 22, proto: "ssh");
 }
}
 
