#TRUSTED 66227dc786cf42b17a16a3cc27a59d5df4b2fa980350cf693b2ed004f1f8e5d45ee567fcebd6071653e2f64e4ca2b761309eb7c3b66f195f1c6340d7ac4d6925262cb3c2f5cf2b5e24e606456220e4281630db3ec50fbb32cb2710316c13a4a54f5837d44d425c3fe395b86e15b879226ddefb6d5b7971ca0fdc18460bf096eefefd360afa09da336dea07b6a9c3fefc6177f901faec5be6e275b27932458aee47479ae039b64fd5d19fc010ab87f152ed5761d89ffefeecc30bbc9b00df12112e647acede12493c90c654744b55ac13bcb9d78878e933c856dcbbd2646830c0fbff15abe9997edbf557af59ddc88bfbafdbbd2ebc4c9f89c30ce5e9175edde61cfc110f2368ca4fadd92db29f9cf3b2521cf2ce8df40590131879969f3521d2b61c7de97f73a77c7e2996b240b5012a7fc528eb5539ef7b8e221666459bca35ce31a67c5395750f941565d7e303c6350a71fbe8874ba69e47050a2787327498fb5d2c915b23c61180e1d9763759a7f140dc05942bb1df14ea966521e7e7001b7844669293f41e97efec227aeec784a33f70386f33040754bd0e628824d7f61b0b56f611462c30d4ad2c8c008cd264f4ee2b9e227b23c7d1fc3ee64f216d9b80a17b5a8f0a85abc50cc42709b5a22e291a79224fb4ce5cffde17d45a3b54b2fa3972c774f99269b5adff8b8930c0836b3b304786c3d5683e436f4da177b59c2a
#
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12634);
 script_version ("1.17");
 name["english"] = "Use SSH to perform local security checks";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
This scripts logs into the remote host using SSH and extracts the list
of installed packages. To work properly, this script requires
that you configure it with a valid SSH public key to use and
eventually an SSH passphrase if the SSH public key is passphrase-protected.";


 script_description(english:desc["english"]);
 
 summary["english"] = "Logs into the remote host using SSH";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "General";
 script_family(english:family["english"]);
 
 script_dependencies("find_service.nes", "ssh_settings.nasl");
 script_require_keys("Secret/SSH/login");
 script_require_ports(22, "Services/ssh");
 exit(0);
}


include("ssh_func.inc");

__gs_opt = get_kb_item("global_settings/report_verbosity");
if (__gs_opt)
       {
       if ("Verbose" >< __gs_opt) report_verbosity = 2;
       else if ("Normal" >< __gs_opt) report_verbosity = 1;
       else if ("Quiet" >< __gs_opt) report_verbosity = 0;
       }



report = "";

port = kb_ssh_transport();
sock = ssh_login_or_reuse_connection();
if ( ! sock ) exit(0);



if ( private_key )
	report = "It was possible to log into the remote host using the supplied asymetric keys"; 
else
	report = "It was possible to log into the remote host using the supplied password"; 


# Determine the remote operating system type

buf = ssh_cmd(socket:sock,cmd:"cmd /C ver");

#------------------------------[ WINDOWS ]-----------------------------------------------#
if ( buf && ("Microsoft Windows" >< buf))
{
  winver = buf;
  fname = "nessus-registry-" + rand() + "-";
  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '1.txt "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Updates"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '2.txt "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\HotFix"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "1.txt " + fname + "2.txt");
  # Store the entries in the KB 
  reg = egrep(pattern:"^\[HKEY_LOCAL_MACHINE.*\]", string:buf);
  flag = 0;
  foreach entry (split(reg))
  { 
  entry = chomp(entry);
  entry = ereg_replace(pattern:"^\[HKEY_LOCAL_MACHINE\\(.*)\]", string:entry, replace:"\1");
  entry = str_replace(find:"\", replace:"/", string:entry);
  name = "SMB/Registry/HKLM/" + entry;
  set_kb_item(name:name, value:TRUE);
  flag ++;
  }

  if ( flag )  set_kb_item(name:"SMB/Registry/Enumerated", value:TRUE);
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "1.txt " + fname + "2.txt");

  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '3.txt "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\ProductOptions"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "3.txt");
  reg = egrep(pattern:"^.ProductType.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"ProductType"="(.*)"', string:chomp(reg), replace:"\1");
   set_kb_item(name:"SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Control/ProductOptions", value:value);
  }
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "3.txt");
  
  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '4.txt "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\W3SVC"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "4.txt");
  reg = egrep(pattern:"^.ImagePath.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"ImagePath"="(.*)"', string:chomp(reg), replace:"\1");
   set_kb_item(name:"SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Services/W3SVC/ImagePath", value:value);
  }
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "4.txt");

 
  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '5.txt "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\DataAccess"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "5.txt");
  reg = egrep(pattern:"^.Version.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"Version"="(.*)"', string:chomp(reg), replace:"\1");
   set_kb_item(name:"SMB/Registry/HKLM/SOFTWARE/Microsoft/DataAccess/Version", value:value);
  }
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "5.txt");

  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '6.txt "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Exchange\\Setup"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "6.txt");
  reg = egrep(pattern:"^.ServicePackBuild.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"ServicePackBuild"="(.*)"', string:chomp(reg), replace:"\1");
   set_kb_item(name:"SMB/Registry/HKLM/SOFTWARE/Microsoft/Exchange/Setup/ServicePackBuild", value:value);
  }
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "6.txt");
 
  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '7.txt "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "7.txt");
  reg = egrep(pattern:"^.CurrentVersion.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"CurrentVersion"="(.*)"', string:chomp(reg), replace:"\1");
   set_kb_item(name:"SMB/WindowsVersion", value:value);
   nt_version = value;
  }
  reg = egrep(pattern:"^.CSDVersion.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"CSDVersion"="(.*)"', string:chomp(reg), replace:"\1");
   if ( nt_version == "4.0" ) set_kb_item(name:"SMB/WinNT4/ServicePack", value:value);
   if ( nt_version == "5.0" ) set_kb_item(name:"SMB/Win2K/ServicePack", value:value);
   if ( nt_version == "5.1" ) set_kb_item(name:"SMB/WinXP/ServicePack", value:value);
   set_kb_item(name:"SMB/RegOverSSH", value:TRUE);
  }
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "7.txt");
  report += '\nThe remote system is Microsoft Windows :' + winver + '\nHotfixes will be checked over SSH instead of SMB whenever possible';
  security_note(port:port, data:report);
  exit(0);
}

buf = ssh_cmd(socket:sock,cmd:"uname -a");
if ( buf ) set_kb_item(name:"Host/uname", value:buf);
else {
	report += 
'\nHowever the execution of the command "uname -a" failed, so local security
checks have not been enabled';
	security_note(port:port, data:report);
	exit(0);
     }


report += '\nThe output of "uname -a" is :\n' + buf;


############################# FreeBSD ###########################################
if ( "FreeBSD" >< buf )
{
  release = ereg_replace(pattern:".*FreeBSD ([0-9]\.[^ ]*).*", replace:"\1", string:buf);
 items = split(release, sep:"-", keep:0);
 if ( "p" >< items[2] ) items[2] = ereg_replace(pattern:"p", replace:"_", string:items[2]);
 release = "FreeBSD-" + items[0] + items[2];
 set_kb_item(name:"Host/FreeBSD/release", value:release); 
  buf = ssh_cmd(socket:sock, cmd:"/usr/sbin/pkg_info", timeout:60);
  if ( ! buf )  {
	report += 
'\nThe command "pkg_info" did not return any result, therefore
FreeBSD local security checks have not been enabled for
this test';
	security_note(port:port, data:report);
	}
  else {
        set_kb_item(name:"Host/FreeBSD/pkg_info", value:buf);
        report += '\nLocal security checks have been enabled for this host.';
	security_note(port:port, data:report);
	exit(0);
	}
}
######################## RedHat Linux ###########################################
else if ("Linux" >< buf )
{
  buf = ssh_cmd(socket:sock, cmd:"cat /etc/redhat-release");
  if ( egrep(pattern:"Red Hat.*(Enterprise|Advanced).*release (3|2\.1)", string:buf) ||
       egrep(pattern:"Fedora Core.*", string:buf) )
  {
   if ( "Red Hat" >< buf ) report += '\nThe remote Red Hat system is :\n' + buf;
   else if ("Fedora" >< buf ) report += '\nThe remote Fedora system is :\n' + buf;
   set_kb_item(name:"Host/RedHat/release", value:buf);
   buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'", timeout:120);

   if ( ! buf )
   {
     report += 
'\nThe command "rpm -qa" did not produce any result, therefore local security 
checks have been disabled';
    security_note(port:port, data:report);
    exit(0);
   }

   report += '\nLocal security checks have been enabled for this host.';
   set_kb_item(name:"Host/RedHat/rpm-list", value:buf);
   security_note(port:port, data:report);
   exit(0);
  }
#####################   Mandrake ####################################################
#Mandrake Linux release 9.1 (Bamboo) for i586
  else
  {
  #buf = ssh_cmd(socket:sock, cmd:"cat /etc/redhat-release");
  if ("Mandrake Linux" >< buf && "Mandrake Linux Corporate" >!< buf )
  {
   if ( "Mandrake" >< buf ) report += '\nThe remote Mandrake system is :\n' + buf;
   version = ereg_replace(pattern:"Mandrake Linux release ([0-9]\.[0-9]) .*", string:egrep(string:buf, pattern:"Mandrake"), replace:"\1");
   set_kb_item(name:"Host/Mandrake/release", value:"MDK" + version);
   
   #report += '\ndebug:\n' + version;
   
   buf = ssh_cmd(socket:sock, cmd:"rpm -qa --qf '%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'", timeout:60);

   if ( ! buf )
   {
     report +=
'\nThe command "rpm -qa" did not produce any result, therefore local security
checks have been disabled';
    security_note(port:port, data:report);
    exit(0);
   }

   report += '\nLocal security checks have been enabled for this host.';
   set_kb_item(name:"Host/Mandrake/rpm-list", value:buf);
   security_note(port:port, data:report);
   exit(0);
  }
  }

###################### SuSE ###############################################################
  buf = ssh_cmd(socket:sock, cmd:"cat /etc/SuSE-release");
  if ( buf )
  {
   	if ( "SuSE Linux" >< buf ) report += '\nThe remote SuSE system is :\n' + egrep(pattern:"^SuSE", string:buf);

	version = ereg_replace(pattern:"SuSE Linux ([0-9]\.[0-9]) .*", string:egrep(string:buf, pattern:"SuSE"), replace:"\1");
  	
   	set_kb_item(name:"Host/SuSE/release", value:"SUSE" + version);
   buf = ssh_cmd(socket:sock, cmd:"rpm -qa --qf '%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'", timeout:60);

   if ( ! buf )
   {
     report += 
'\nThe command "rpm -qa" did not produce any result, therefore local security 
checks have been disabled';
    security_note(port:port, data:report);
    exit(0);
   }

   report += '\nLocal security checks have been enabled for this host.';
   set_kb_item(name:"Host/SuSE/rpm-list", value:buf);
   security_note(port:port, data:report);
   exit(0);
  }
  
###################### Gentoo ###############################################
  buf = ssh_cmd(socket:sock, cmd:"cat /etc/gentoo-release");
  if ( buf )
  {
    if ( "Gentoo" >< buf )
      report += '\nThe remote Gentoo system is :\n' + egrep(pattern:"^Gentoo", string:buf);
    version = ereg_replace(pattern:"Gentoo Base System version ([0-9]\.[0-9]) .*",
                             string:egrep(string:buf, pattern:"Gentoo"), replace:"\1");
    # Release does not make much sense on Gentoo
    set_kb_item(name:"Host/Gentoo/release", value: version);

    buf = ssh_cmd(socket: sock, timeout: 60, cmd: 'egrep "ARCH=" /etc/make.profile/make.defaults');
    buf = ereg_replace(string: buf, pattern: 'ARCH="(.*)"', replace: "\1");
    set_kb_item(name: "Host/Gentoo/arch", value: buf);

    # A great idea from David Maciejak: 
    # 1. app-portage/gentoolkit is not necessarily installed 
    # 2. and this find is quicker than "qpkg -v -I -nc"
    buf = ssh_cmd(socket:sock, timeout:60, 
     cmd:'find /var/db/pkg/ -mindepth 2 -maxdepth 2 -printf "%P\\n"');
    if (buf)
    {
      report += '\nLocal security checks have been enabled for this host.';
      set_kb_item(name:"Host/Gentoo/qpkg-list", value:buf);
      security_note(port:port, data:report);
    }
    else
    {
      report += 
'For any reason, find did not produce any result, therefore local security 
checks have been disabled';
     security_note(port:port, data:report);
    }
    exit(0);
    }

###################### Debian ###############################################
  buf = ssh_cmd(socket:sock, cmd:"cat /etc/debian_version");
  if ( buf )
  {
    report += '\nThe remote Debian system is :\n' + buf;
    if (buf !~ '^[0-9.]+[ \t\r\n]*$')
    {
      report += '\nThe Debian version is unknown, or testing / unstable, 
therefore local security checks have been disabled\n';
      security_note(port:port, data:report);
      exit(0);
    }
    set_kb_item(name:"Host/Debian/release", value: chomp(buf));

    buf = ssh_cmd(socket:sock, timeout:60, cmd:'COLUMNS=160 dpkg -l');
    if (buf)
    {
      report += '\nLocal security checks have been enabled for this host.';
      set_kb_item(name:"Host/Debian/dpkg-l", value:buf);
      security_note(port:port, data:report);
    }
    else
    {
      report += 
'For any reason, dpkg did not produce any result, therefore local security 
checks have been disabled';
    security_note(port:port, data:report);
    }
    exit(0);
  }

  report += 
'\nThe remote Linux distribution is not supported, therefore local security checks have not been enabled';
  security_note(port:port, data:report);
  exit(0);
}
######################## MacOS X ###########################################
else if ("Darwin" >< buf )
 {
  operating_system = ereg_replace(pattern:"^.*Darwin Kernel Version ([0-9]+\.[0-9]+\.[0-9]+):.*$", string:buf, replace:"\1");

  num = split(operating_system, sep:".", keep:FALSE);
  version = "Mac OS X 10." + string(int(num[0]) - 4) + "." + int(num[1]);


  buf = ssh_cmd(socket:sock, cmd:"ls /private/etc/sysctl-macosxserver.conf");
  if ( strlen(buf) ) version = version + " Server";
  set_kb_item(name:"Host/MacOSX/Version", value:version);
  buf = ssh_cmd(socket:sock, cmd:"ls /Library/Receipts");
  if ( ! buf )
  {
   report += 
'\nIt was not possible to get the list of installed package on the 
remote MacOS X system, therefore local security checks have
been disabled';
   security_note(port:port, data:report);
   exit(0);
  }
  set_kb_item(name:"Host/MacOSX/packages", value:buf);
  report += '\nLocal security checks have been enabled for this host.';
  security_note(port:port, data:report);
 }
######################## Solaris ###########################################
else if ( egrep(pattern:"SunOS.*", string:buf) )
{
 buf = ssh_cmd(socket:sock, cmd:"showrev -a", timeout:60);
 if ( ! buf )
 {
  report += 
'\nIt was not possible to gather the list of installed packages on the
remote Solaris system, therefore local security checks have been disabled.';
  security_note(port:port, data:report);
  exit(0);
 }

 set_kb_item(name:"Host/Solaris/showrev", value:buf);

 buf = egrep(pattern:"^Release: ", string:buf);
 buf -= "Release: ";
 set_kb_item(name:"Host/Solaris/Version", value:buf);

 buf = ssh_cmd(socket:sock, cmd:"/usr/bin/pkginfo", timeout:120);
 if ( ! buf ) {
report = '\nIt was not possible to gather the list of installed packages on the
remote Solaris system, therefore local security checks have been disabled.';
  security_note(port:port, data:report);
  exit(0);
 }

  set_kb_item(name:"Host/Solaris/pkginfo", value:buf);
  report += '\nLocal security checks have been enabled for this host.';
  security_note(port:port, data:report);
}
############################# AIX ##############################################
else if ( "AIX" >< buf )
{
  release = ereg_replace(pattern:".*AIX[ ]+.*[ ]+([0-9]+[ ]+[0-9]+)[ ]+.*", replace:"\1", string:buf);
  items = split(release, sep:" ", keep:0);
  release = "AIX-" + items[1] + "." + items[0];
  set_kb_item(name:"Host/AIX/version", value:release); 

  buf = ssh_cmd(socket:sock, cmd:"oslevel -r", timeout:60);
  if ( buf )  set_kb_item(name:"Host/AIX/oslevel", value:buf);

  buf = ssh_cmd(socket:sock, cmd:"lslpp -Lc", timeout:60);
  if ( ! buf ) {
    report += 
'\nThe command "lslpp -Lc" did not return any result, therefore
AIX local security checks have not been enabled for
this test';
    security_note(port:port, data:report);
    exit(0);
  }
  set_kb_item(name:"Host/AIX/lslpp", value:buf);
  report += '\nLocal security checks have been enabled for this host.';
  security_note(port:port, data:report);
  exit(0);
}



#------------------------------------------------------------------------#
# Misc calls (all Unixes)						 #
#------------------------------------------------------------------------#

# cfengine version 
ver = ssh_cmd(socket:sock, cmd:"/usr/sbin/cfservd --help | grep ^cfengine | cut -d '-' -f 2", timeout:60);
if ( ver )
{
 ver = chomp(ver);
 set_kb_item(name:string("cfengine/version"), value:ver);
}





ssh_close_connection();
