/*
 *  File: SG_Button.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

#ifndef SG_BUTTON_H
#define SG_BUTTON_H

class SG_Button : public SG_Window
{
public:
	SG_Bitmap *bitmaps[SG_MOUSE_COUNT];
	int DownOffsetX, DownOffsetY;

	SG_Button();
	void SetBitmap(int mouseState, SG_Bitmap *aBitmap) {bitmaps[mouseState] = aBitmap;}
	SG_Bitmap* Bitmap(int mouseState) {return bitmaps[mouseState];}
	void SetDownOffset(int x, int y) {DownOffsetX = x; DownOffsetY = y;}
	SG_Point DownOffset() {SG_Point pt(DownOffsetX, DownOffsetY); return pt;}

	//virtual overrides
	virtual void Draw(SG_Graphics *gfx);
	virtual void MouseDown(int x, int y);
	virtual void MouseUp(int x, int y);
	virtual void MouseEnter();
	virtual void MouseLeave();
	
	//events
	void (*OnClick)(SG_Window *source);
};

#endif