/*
 *  File: SG_CheckGroup.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

#ifndef SG_CHECKGROUP_H
#define SG_CHECKGROUP_H

class SG_CheckGroup
{
public:
    LinkedList lst;
    int check;
	
	class SG_CheckGroupBtn : public SG_CheckButton
	{
	public:
		SG_CheckGroup *grp;
		
		void MouseDown(int x, int y)
		{
			SG_CheckButton::MouseDown(x,y);
			
			int i=0; for (Position *p=grp->lst.First(); !grp->lst.End(p); p=grp->lst.Next(p), i++)
			{
				SG_CheckGroupBtn *chk = (SG_CheckGroupBtn*)grp->lst.ElementAt(p);
				
				if (chk != this)
					chk->SetState(SG_UNCHECKED);
				else
				{
					chk->state = SG_CHECKED;
					grp->check = i;
				}
	        } 			
		}
	};
	    
public:
    SG_CheckGroup()
    {lst.SetDeleteOnRemoval(false);}
    
    SG_CheckGroup(SG_CheckGroupBtn *chk[], int size)
    {
        AddCheckBtn(chk, size);
    }    
        
    void AddCheckBtn(SG_CheckGroupBtn *chk)
    {
		lst.Add((Element*)chk);
		chk->grp=this;
	}
    
    void AddCheckBtn(SG_CheckGroupBtn *chk[], int size)
    {
		for (int i=0; i<size; i++) AddCheckBtn(chk[i]);
	}    
    
    void SetCheck(int index)
    {
		int i=0; for (Position *p=lst.First(); !lst.End(p); p=lst.Next(p), i++)
		{
			if (i==index)
                ((SG_CheckGroupBtn*)lst.ElementAt(p))->SetState(SG_CHECKED);
            else
                ((SG_CheckGroupBtn*)lst.ElementAt(p))->SetState(SG_UNCHECKED);
        }
        
        check = index;
    }
    
    int GetCheck() {return check;}
};
typedef SG_CheckGroup::SG_CheckGroupBtn SG_CheckGroupBtn;

#endif