/*
 *  File: SG_ExtendFrame.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

#ifndef SG_EXTENDFRAME_H
#define SG_EXTENDFRAME_H

class SG_ExtendFrame : public SG_Window
{
	SG_Rect rcHeader;
	SG_Rect rcClient;
	bool bExtended;
	int iClientHeight;

public:	
	SG_ExtendFrame();

	void Extend(bool extended);
	bool IsExtended() {return bExtended;}
	void SetClientHeight(int height);
	int ClientHeight() {return iClientHeight;}

	virtual void DrawHeader(SG_Graphics *gfx, SG_Rect &rect);
	virtual void DrawClient(SG_Graphics *gfx, SG_Rect &rect);
	
	//overrides
	virtual void Draw(SG_Graphics *gfx);
	virtual void ApplyBounds(int x, int y, int w, int h);
	virtual void MouseDown(int x, int y);
	
	//events
	void (*OnExtend) (bool extended, SG_Window *source);
};

#endif
