/*
 *  File: SG_Font.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */

void SG_InitTTF();

struct SG_Glyph
{
	UNICODE code;
	int advance;
	int distLeft;
	int distTop;
	SG_Bitmap *page;
	SG_Rect bounds;
};

class SG_Font
{
private:
	FT_Face face;
	int size;
	SG_Color color;
	bool hasKerning;
	
	LinkedList glyphs;
	int nextX, nextY;
	LinkedList pages;
	SG_Bitmap *lastPage;
	
	LinkedList colorVariants;

	void InitASCI();
	void InitBlank();
	SG_Font* AddColorVariant(SG_Color &newColor);
	SG_Bitmap* AddPage();
	SG_Glyph* AddGlyph(UNICODE c);
			
public:
	int Size() {return size;}
	int Height() {return size;}
	void SetColor(SG_Color &newColor);
	SG_Color Color() {return color;}
	SG_Glyph* Glyph(UNICODE code);
	int Kerning(UNICODE codeLeft, UNICODE codeRight);
	void FromFile(const char *fileName, int fontSize);
	SG_Font* ColorVariant(SG_Color &aColor);
};

int SG_CharWidth(UNICODE code, SG_Font *font);
int SG_TextWidth(SG_String &str, int count, SG_Font *font);
int SG_TextWidth(SG_String &str, SG_Font *font);

extern FT_Library fontLibrary;
extern SG_Font *SG_drawFont;