/*
 *  File: SG_Graphics.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */
 
#ifndef SG_GRAPHICS_H
#define SG_GRAPHICS_H

class SG_Graphics
{
private:
	SDL_Surface *targetSurface;
	int targetFormat;
	bool isAlphaTarget;
	bool isRasterTarget;
	SG_Point drawingOffset;
	SG_Color penColor;
	SG_Color fillColor;
	float fPenR, fPenG, fPenB, fPenA;
	float fFillR, fFillG, fFillB, fFillA;
	SG_Font *font;
	
	void TileBitmapPart(SG_Bitmap &bmp, SG_Rect &rcSrc, SG_Rect &rcDst, int tileDirection);
	void DrawBitmapPart(SG_Bitmap &bmp, SG_Rect &rcSrc, SG_Rect &rcDst);
	
public:
	void FromBitmap(SG_Bitmap &aBitmap);
	void FromScreen();
	
	void SetPenColor(SG_Color &color);
	void SetFillColor(SG_Color &color);
	void SetPenColor(BYTE R, BYTE G, BYTE B, BYTE A=255);
	void SetFillColor(BYTE R, BYTE G, BYTE B, BYTE A=255);
	void SetFont(SG_Font *aFont);
	void SetDrawingOffset(int x, int y) {drawingOffset.Set(x,y);}
	
	void DrawPixel(int x, int y);
	void DrawLine(int x1, int y1, int x2, int y2);
	void DrawLine(SG_Point &pt1, SG_Point &pt2);
	void DrawRect(SG_Rect &rc);
	void FillRect(SG_Rect &rc);
	void Draw3DRect(SG_Rect &rect, int type);	
	
	void DrawBitmap(SG_Bitmap &bmp, SG_Point &ptDst);
	void DrawBitmap(SG_Bitmap &bmp, SG_Rect &rcDst);
	void DrawBitmap(SG_Bitmap &bmp, SG_Rect &rcSrc, SG_Rect &rcDst);
	void DrawBitmapTiled(SG_Bitmap &bmp, SG_Rect &rectDst);
	void DrawBitmapRotated(SG_Bitmap &bmp, SG_Rect &rcDst, float angle);
	void DrawBitmapRotated(SG_Bitmap &bmp, SG_Rect &rcSrc, SG_Rect &rcDst, float angle);
	
	void DrawChar(UNICODE code, int x, int y);
	void DrawText(const SG_String &text, int x, int y);		
};

#endif
