/*
 *  File: SG_List.h
 *  Project: ShmanssyGUI
 *
 *  Written by: Ivan Leben
 *  Licence: GNU GPL
 *
 */
 
#ifndef SEZNAM_H
#define SEZNAM_H

//***************************//
//  implementacija s poljem  //
//***************************//

class Element
{
public:
	virtual bool Equals (Element *el)
	{
		return (this == el);
	}
};

class Position
{
};

class ArrayList
{
private:
	int max_size;
	Element **elements;
	bool delete_on_remove;

public:
	//memory
	int size;
	ArrayList(bool DeleteOnRemoval);
	~ArrayList();
	void AllocMore(); // O(n)
	
	void SetDeleteOnRemoval(bool bDelete)
	{delete_on_remove = bDelete;}	

	//elements
	void Add(Element *new_el); // O(1)
	void Remove(Element *el); // O(n)
	void RemoveAt(int index); // O(n)
	Element* ElementAt(int index); // O(1)
	Element* ElementAt(Position *pos); // O(1)
	void SetAt(Position *pos, Element* el); // O(1)
	int IndexOf(Element *el); // O(n)

	//searching
	Position* First(); // O(1)
	Position* Next(Position *pos); // O(n)
	bool End(Position *pos); // O(1)
};

//****************************//
//  implementacija s kazalci  //
//****************************//

class LINK : public Position
{
public:
	Element *element;
	LINK *next;
};

class LinkedList
{
private:
	LINK start;
	LINK *first;
	LINK *last;
	bool delete_on_remove;

public:
	//memory
	int size;
	int Size() {return size;}
	
	LinkedList();
	LinkedList(bool DeleteOnRemoval);
	~LinkedList();
	
	void SetDeleteOnRemoval(bool bDelete)
	{delete_on_remove = bDelete;}

	//elements
	void Clear();
	bool Includes(Element *el); //O(n)
	Position *Find(Element *el); //O(n)
	void AddFirst(Element *new_el); //O(1)
	void Add(Element *new_el); // O(1)
	void Remove(Element *el); // O(n)
	void RemoveAt(int index); // O(n)
	void RemoveAt(Position *pos); // O(1)
	void InsertAt(Position *pos, Element *new_el); //O(1)
	Element* ElementAt(int index); // O(n)
	Element* ElementAt(Position *pos); // O(1)
	void SetAt(Position *pos, Element* el); // O(1)

	//searching
	Position* First(); // O(1)
	Position* Next(Position *pos); // O(1)
	bool End(Position *pos); // O(1)
};

//***************************************//
//  implementacija z indeksnimi kazalci  //
//***************************************//

class INDEX_LINK : public Position
{
public:
	Element *element;
	int next;
};

class CursorList
{
private:
	int max_size;
	int last;
	INDEX_LINK *links;
	bool delete_on_remove;

public:
	//memory
	CursorList(bool DeleteOnRemoval);
	~CursorList();
	void AllocMore(); // O(n + 1000)
	
	void SetDeleteOnRemoval(bool bDelete)
	{delete_on_remove = bDelete;};	

	//elements
	void Add(Element *new_el); // O(1)
	void Remove(Element *el); // O(n)
	void RemoveAt(int index); // O(n)
	void RemoveAt(Position *pos); // O(1)
	Element* ElementAt(int index); // O(n)
	Element* ElementAt(Position *pos); // O(1)
	void SetAt(Position *pos, Element* el); // O(1)

	//searching
	Position* First(); // O(1)
	Position* Next(Position *pos); // O(1)
	bool End(Position *pos); // O(1)
};

typedef ArrayList List;

#endif
